function generateRandomName() {
  const names = [
    'Alice',
    'Bob',
    'Charlie',
    'Dave',
    'Eve',
    'Frank',
    'Grace',
    'Hank',
    'Ivy',
    'Jack',
    'Kate',
    'Liam',
    'Mia',
    'Noah',
    'Olivia',
    'Patrick',
    'Quinn',
    'Riley',
    'Sarah',
    'Thomas',
    'Uma',
    'Victor',
    'Wendy',
    'Xavier',
    'Yara',
    'Zachary',
    'Abigail',
    'Benjamin',
    'Chloe',
    'Daniel',
  ];
  const randomIndex = Math.floor(Math.random() * names.length);
  return names[randomIndex];
}

function generateRandomNumber() {
  return Math.floor(Math.random() * (14400 - 750 + 1)) + 750;
}

function generateRandomCountry() {
  const countries = [
    {
      name: 'Denmark',
      flag: 'flag-icon-dk',
    },
    {
      name: 'Sweden',
      flag: 'flag-icon-se',
    },
    {
      name: 'Switzerland',
      flag: 'flag-icon-ch',
    },
    {
      name: 'Ireland',
      flag: 'flag-icon-ie',
    },
    {
      name: 'England',
      flag: 'flag-icon-gb',
    },
    {
      name: 'Denmark',
      flag: 'flag-icon-dk',
    },
    {
      name: 'Belgium',
      flag: 'flag-icon-be',
    },
    {
      name: 'Germany',
      flag: 'flag-icon-de',
    },
    {
      name: 'Finland',
      flag: 'flag-icon-fi',
    },
  ];
  const randomIndex = Math.floor(Math.random() * countries.length);
  return countries[randomIndex];
}

function generateTable() {
  const tableContainer = document.getElementById('tableContainer');
  tableContainer.innerHTML = '';

  const stickyRow = document.createElement('div');
  stickyRow.classList.add('rownumber', 'sticky');
  const nameHeader = document.createElement('div');
  nameHeader.classList.add('names');
  nameHeader.innerHTML = '<strong>Name</strong>';
  stickyRow.appendChild(nameHeader);
  const numberHeader = document.createElement('div');
  numberHeader.classList.add('numbers');
  numberHeader.innerHTML = '<strong>Earn</strong>';
  stickyRow.appendChild(numberHeader);
  const countryHeader = document.createElement('div');
  countryHeader.classList.add('countrys');
  countryHeader.innerHTML = '<strong>Country</strong>';
  stickyRow.appendChild(countryHeader);
  tableContainer.appendChild(stickyRow);

  for (let i = 0; i < 10; i++) {
    const rownumber = document.createElement('div');
    rownumber.classList.add('rownumber');

    const name = document.createElement('div');
    name.classList.add('names');
    name.textContent = generateRandomName();
    rownumber.appendChild(name);

    const number = document.createElement('div');
    number.classList.add('numbers');
    const randomNumber = generateRandomNumber();
    number.textContent = `${randomNumber} £`;
    rownumber.appendChild(number);

    const countryData = generateRandomCountry();
    const country = document.createElement('div');
    country.classList.add('countrys');
    const flag = document.createElement('span');
    flag.classList.add('flag-icon', 'flag-icon-squared', countryData.flag);
    country.appendChild(flag);
    country.innerHTML += ` ${countryData.name}`;
    rownumber.appendChild(country);

    tableContainer.appendChild(rownumber);
  }
}

setInterval(generateTable, 5000);
