document.addEventListener('DOMContentLoaded', () => {
  const counter = document.getElementById('counter');
  const targetNumber = 408754243.5;
  const duration = 180000; // duration in milliseconds

  function animateCounter(start, end, duration) {
    let startTime = null;

    function updateCounter(currentTime) {
      if (startTime === null) startTime = currentTime;
      const progress = Math.min((currentTime - startTime) / duration, 1);
      const currentNumber = start + (end - start) * progress;
      counter.textContent = currentNumber.toLocaleString(undefined, {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2,
      });

      if (progress < 1) {
        requestAnimationFrame(updateCounter);
      }
    }

    requestAnimationFrame(updateCounter);
  }

  animateCounter(0, targetNumber, duration);
});
